CREATE TABLE `jlr_delfor_header` (
  `ID` varchar(35) NOT NULL,
  `STATUS` int NOT NULL,
  `DOC_NUMBER` varchar(45) DEFAULT NULL,
  `CREATE_DATETIME` datetime DEFAULT NULL,
  `END_DATETIME` datetime DEFAULT NULL,
  `PRE_RELEASE_NO` varchar(45) DEFAULT NULL,
  `BUYER_PARTNER_NUMBER` varchar(45) DEFAULT NULL,
  `MATERIAL_ISSUER_PARTNER_NUMBER` varchar(45) DEFAULT NULL,
  `SHIPFROM_PARTNER_NUMBER` varchar(45) DEFAULT NULL,
  `SHIPTO_PARTNER_NUMBER` varchar(45) DEFAULT NULL,
  `SUPPLIER_PARTNER_NUMBER` varchar(45) DEFAULT NULL,
  UNIQUE KEY `ID_UNIQUE` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `jlr_delfor_item` (
  `ID` varchar(35) NOT NULL,
  `STATUS` int NOT NULL,
  `HEADER_ID` varchar(35) NOT NULL,
  `BUYER_ITEM_NUMBER` varchar(45) DEFAULT NULL,
  `PLANT` varchar(45) DEFAULT NULL,
  `UNLOADING_POINT` varchar(45) DEFAULT NULL,
  `PO_NUMBER` varchar(45) DEFAULT NULL,
  `PO_LINE` varchar(45) DEFAULT NULL,
  `LAST_RECEIPT_QTY` decimal(18,0) DEFAULT NULL,
  `CUMULATIVE_QTY` decimal(18,0) DEFAULT NULL,
  `LAST_DELIVERY_NOTE` varchar(45) DEFAULT NULL,
  `LAST_RECEIPT_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `DELFOR_HEADER_idx` (`HEADER_ID`),
  CONSTRAINT `DELFOR_HEADER` FOREIGN KEY (`HEADER_ID`) REFERENCES `jlr_delfor_header` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `jlr_delfor_details` (
  `ID` varchar(35) NOT NULL,
  `STATUS` int NOT NULL,
  `ITEM_ID` varchar(45) NOT NULL,
  `PLAN_STATUS` varchar(45) DEFAULT NULL,
  `BACKLOG_QTY` decimal(18,0) DEFAULT NULL,
  `DELIVERY_QUANTITY` decimal(18,0) DEFAULT NULL,
  `EARLIEST_DELIVERY_DATE` datetime DEFAULT NULL,
  `LATEST_DELIVERY_DATE` datetime DEFAULT NULL,
  `DELIVERY_DATETIME` datetime DEFAULT NULL,
  `SHIPMENT_DATETIME` datetime DEFAULT NULL,
  `PLANNER` varchar(45) DEFAULT NULL,
  `REQUIREMENT_DESC` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `DELFOR_HEADER_idx` (`ITEM_ID`),
  CONSTRAINT `DELFOR_ITEM` FOREIGN KEY (`ITEM_ID`) REFERENCES `jlr_delfor_item` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `jlr_deljit_header` (
  `ID` varchar(35) NOT NULL,
  `STATUS` int NOT NULL,
  `DOC_NUMBER` varchar(35) DEFAULT NULL,
  `CREATE_DATETIME` datetime DEFAULT NULL,
  `START_DATETIME` datetime DEFAULT NULL,
  `END_DATETIME` datetime DEFAULT NULL,
  `PRE_RELEASE_NO` varchar(35) DEFAULT NULL,
  `BUYER_PARTNER_NUMBER` varchar(35) DEFAULT NULL,
  `MATERIAL_ISSUER_PARTNER_NUMBER` varchar(35) DEFAULT NULL,
  `SHIPFROM_PARTNER_NUMBER` varchar(35) DEFAULT NULL,
  `SHIPTO_PARTNER_NUMBER` varchar(35) DEFAULT NULL,
  `SUPPLIER_PARTNER_NUMBER` varchar(35) DEFAULT NULL,
  `FINAL_RECIPENT_PARTNER_NUMBER` varchar(35) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `ID_UNIQUE` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `jlr_deljit_item` (
  `ID` varchar(35) NOT NULL,
  `STATUS` int NOT NULL,
  `HEADER_ID` varchar(35) NOT NULL,
  `BUYER_ITEM_NUMBER` varchar(45) DEFAULT NULL,
  `PO_NUMBER` varchar(45) DEFAULT NULL,
  `POS_NUMBER` varchar(45) DEFAULT NULL,
  `PLANT1` varchar(45) DEFAULT NULL,
  `UNLOADING_POINT` varchar(45) DEFAULT NULL,
  `STORE` varchar(45) DEFAULT NULL,
  `LAST_RECEIPT_QTY` decimal(18,0) DEFAULT NULL,
  `LAST_DELIVERY_NOTE` varchar(45) DEFAULT NULL,
  `LAST_RECEIPT_DATE` datetime DEFAULT NULL,
  `CUMULATIVE_QTY` decimal(18,0) DEFAULT NULL,
  `PLANT2` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `ID_UNIQUE` (`ID`),
  KEY `JLR_DELJIT_HEADER_IETM_idx` (`HEADER_ID`),
  CONSTRAINT `JLR_DELJIT_HEADER_IETM` FOREIGN KEY (`HEADER_ID`) REFERENCES `jlr_deljit_header` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `jlr_deljit_detail` (
  `ID` varchar(35) NOT NULL,
  `STATUS` int NOT NULL,
  `ITEM_ID` varchar(35) NOT NULL,
  `PLAN_STATUS` varchar(45) DEFAULT NULL,
  `DELIVERY_DATETIME` datetime DEFAULT NULL,
  `BACKLOG_QUANTITY` decimal(18,0) DEFAULT NULL,
  `DELIVERY_QUANTITY` decimal(18,0) DEFAULT NULL,
  `UNIT_OF_MEASURE` varchar(45) DEFAULT NULL,
  `FREQUENCY_CODE` varchar(45) DEFAULT NULL,
  `SHIPMENT_DATETIME` datetime DEFAULT NULL,
  `GOOD_RECEIPT_DATETIME` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `ID_UNIQUE` (`ID`),
  KEY `JLE_DELJIT_ITEM_DETAIL_idx` (`ITEM_ID`),
  CONSTRAINT `JLE_DELJIT_ITEM_DETAIL` FOREIGN KEY (`ITEM_ID`) REFERENCES `jlr_deljit_item` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `jlr_desadv_header` (
  `ID` varchar(35) NOT NULL,
  `STATUS` int NOT NULL,
  `DELIVERY_NO` varchar(45) DEFAULT NULL,
  `ETA_DATETIME` datetime DEFAULT NULL,
  `DELIVERY_DATETIME` datetime DEFAULT NULL,
  `CREATE_DATETIME` datetime DEFAULT NULL,
  `SHIPMENT_GROSS_WEIGHT` decimal(18,4) DEFAULT NULL,
  `SHIPMENT_NET_WEIGHT` decimal(18,4) DEFAULT NULL,
  `PO_NUMBER` varchar(45) DEFAULT NULL,
  `BILL_OF_LADING` varchar(45) DEFAULT NULL,
  `SHIPFROM_PARTNER_NUMBER` varchar(45) DEFAULT NULL,
  `SHIPTO_PARTNER_NUMBER` varchar(45) DEFAULT NULL,
  `SUPPLIER_PARTNER_NUMBER` varchar(45) DEFAULT NULL,
  `FINAL_RECIPENT_PARTNER_NUMBER` varchar(45) DEFAULT NULL,
  `EQUIPMENT_ID` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `ID_UNIQUE` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `jlr_desadv_pack` (
  `ID` varchar(35) NOT NULL,
  `STATUS` int NOT NULL,
  `HEADER_ID` varchar(35) NOT NULL,
  `NUMBER_OF_BOX` int DEFAULT NULL,
  `QUANTITY_PER_BOX` decimal(18,0) DEFAULT NULL,
  `BUYER_PACK_NUMBER` varchar(45) DEFAULT NULL,
  `PALLET_NUMBER` varchar(45) DEFAULT NULL,
  `BOX_NUMBER` text,
  `BOX_PER_PALLET` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `ID_UNIQUE` (`ID`),
  KEY `JLR_DESADV_PACK_HEAER_idx` (`HEADER_ID`),
  CONSTRAINT `JLR_DESADV_PACK_HEAER` FOREIGN KEY (`HEADER_ID`) REFERENCES `jlr_desadv_header` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `jlr_desadv_item` (
  `ID` varchar(35) NOT NULL,
  `STATUS` int NOT NULL,
  `HEADER_ID` varchar(35) DEFAULT NULL,
  `POS_NUMBER` varchar(45) DEFAULT NULL,
  `BUYER_ITEM_NUMBER` varchar(45) DEFAULT NULL,
  `PO_NUMBER` varchar(45) DEFAULT NULL,
  `ITEM_NET_WEIGHT` decimal(18,4) DEFAULT NULL,
  `DELIVERY_QUANTITY` decimal(18,4) DEFAULT NULL,
  `UNIT_OF_MEASURE` varchar(45) DEFAULT NULL,
  `DELIVERY_DATETIME` datetime DEFAULT NULL,
  `PLANT` varchar(45) DEFAULT NULL,
  `BATCH_NUMBER` varchar(45) DEFAULT NULL,
  `PACK_ID` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `ID_UNIQUE` (`ID`),
  KEY `JLR_DESADV_ITEM_HEADER_idx` (`HEADER_ID`),
  KEY `JLR_DESADV_PACK_ITEM_idx` (`PACK_ID`),
  CONSTRAINT `JLR_DESADV_ITEM_HEADER` FOREIGN KEY (`HEADER_ID`) REFERENCES `jlr_desadv_header` (`ID`),
  CONSTRAINT `JLR_DESADV_PACK_ITEM` FOREIGN KEY (`PACK_ID`) REFERENCES `jlr_desadv_pack` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
